import { auth } from '@/app/auth';
import { redirect } from 'next/navigation';
import WordDetailPage from '@/app/components/WordDetailPage';
import { listWordsByBook } from '@/app/db';

interface PageProps {
  params: {
    bookId: string;
    idx: string;
  };
}

export default async function WordPage({ params }: PageProps) {
  const session = await auth();
  
  // Redirect to login if not authenticated
  if (!session) {
    redirect('/me?auth=login');
  }

  const idx = Number.parseInt(params.idx, 10);
  const dbWords = await listWordsByBook(params.bookId);
  const row = dbWords[idx];
  const serverWord = row
    ? {
        id: row.id,
        idx,
        wordRank: row.wordRank ?? 0,
        headWord: row.headWord ?? '',
        content: row.content, // JSON
        bookId: row.bookId ?? params.bookId,
      }
    : null;

  return (
    <WordDetailPage
      bookId={params.bookId}
      idx={idx}
      session={session}
      serverWord={serverWord as any}
    />
  );
}
